<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

if ( ! class_exists( 'Adams_Comms_Elementor_Form_Widget' ) && class_exists( '\Elementor\Widget_Base' ) ) {

    class Adams_Comms_Elementor_Form_Widget extends \Elementor\Widget_Base {

        public function get_name() {
            return 'adams_comms_form';
        }

        public function get_title() {
            return __( "Adam's Comms Form", 'adams-comms' );
        }

        public function get_icon() {
            return 'eicon-mail';
        }

        public function get_categories() {
            return array( 'general' );
        }

        public function get_keywords() {
            return array( 'contact', 'form', 'comms', 'adam' );
        }

        protected function register_controls() {
            $this->start_controls_section(
                'section_content',
                array(
                    'label' => __( 'Form', 'adams-comms' ),
                    'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
                )
            );

            $this->add_control(
                'show_heading',
                array(
                    'label'        => __( 'Show heading text', 'adams-comms' ),
                    'type'         => \Elementor\Controls_Manager::SWITCHER,
                    'label_on'     => __( 'Yes', 'adams-comms' ),
                    'label_off'    => __( 'No', 'adams-comms' ),
                    'return_value' => 'yes',
                    'default'      => '',
                )
            );

            $this->add_control(
                'heading_text',
                array(
                    'label'       => __( 'Heading', 'adams-comms' ),
                    'type'        => \Elementor\Controls_Manager::TEXT,
                    'default'     => __( 'Send us a message', 'adams-comms' ),
                    'label_block' => true,
                    'condition'   => array(
                        'show_heading' => 'yes',
                    ),
                )
            );

            $this->add_control(
                'intro_text',
                array(
                    'label'       => __( 'Intro text', 'adams-comms' ),
                    'type'        => \Elementor\Controls_Manager::TEXTAREA,
                    'default'     => __( 'Fill in the form and we will get back to you.', 'adams-comms' ),
                    'label_block' => true,
                    'condition'   => array(
                        'show_heading' => 'yes',
                    ),
                )
            );

            $this->end_controls_section();
        }

        protected function render() {
            $settings = $this->get_settings_for_display();

            if ( isset( $settings['show_heading'] ) && 'yes' === $settings['show_heading'] ) {
                echo '<div class="adams-comms-form-heading">';
                if ( ! empty( $settings['heading_text'] ) ) {
                    echo '<h3 class="adams-comms-form-title">' . esc_html( $settings['heading_text'] ) . '</h3>';
                }
                if ( ! empty( $settings['intro_text'] ) ) {
                    echo '<p class="adams-comms-form-intro">' . esc_html( $settings['intro_text'] ) . '</p>';
                }
                echo '</div>';
            }

            echo do_shortcode( '[adams_comms_form]' );
        }

        protected function content_template() {
            ?>
            <# if ( settings.show_heading === 'yes' ) { #>
                <div class="adams-comms-form-heading">
                    <# if ( settings.heading_text ) { #>
                        <h3 class="adams-comms-form-title">{{ settings.heading_text }}</h3>
                    <# } #>
                    <# if ( settings.intro_text ) { #>
                        <p class="adams-comms-form-intro">{{ settings.intro_text }}</p>
                    <# } #>
                </div>
            <# } #>
            <div class="adams-comms-form-placeholder">
                <em><?php echo esc_html__( "Adam's Comms form will appear here on the front-end.", 'adams-comms' ); ?></em>
            </div>
            <?php
        }
    }
}
